/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1313;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_265;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.ImmPtlEntityExtension;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.compat.iris_compatibility.IrisInterface;
import qouteall.imm_ptl.core.mc_utils.IPEntityEventListenableEntity;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.network.ImmPtlNetworking;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.GeometryPortalShape;
import qouteall.imm_ptl.core.portal.IntraClusterRelation;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.PortalExtension;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.animation.AnimationView;
import qouteall.imm_ptl.core.portal.animation.DefaultPortalAnimation;
import qouteall.imm_ptl.core.portal.animation.PortalAnimation;
import qouteall.imm_ptl.core.portal.animation.PortalAnimationDriver;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.PortalShapeSerialization;
import qouteall.imm_ptl.core.portal.shape.RectangularPortalShape;
import qouteall.imm_ptl.core.portal.shape.SpecialFlatPortalShape;
import qouteall.imm_ptl.core.render.renderer.PortalRenderer;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Mesh2D;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.TriangleConsumer;

public class Portal
extends class_1297
implements PortalLike,
IPEntityEventListenableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_1299<Portal> ENTITY_TYPE = Portal.createPortalEntityType(Portal::new);
    public static final Event<Consumer<Portal>> CLIENT_PORTAL_ACCEPT_SYNC_EVENT = Helper.createConsumerEvent();
    public static final Event<Consumer<Portal>> CLIENT_PORTAL_SPAWN_EVENT = Helper.createConsumerEvent();
    private static final class_238 NULL_BOX = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    protected double width = 0.0;
    protected double height = 0.0;
    protected double thickness = 0.0;
    protected class_243 axisW;
    protected class_243 axisH;
    protected class_5321<class_1937> dimensionTo;
    protected class_243 destination;
    protected boolean teleportable = true;
    @Nullable
    protected PortalShape portalShape;
    @Nullable
    public UUID specificPlayerId;
    @Nullable
    protected DQuaternion rotation;
    protected double scaling = 1.0;
    protected boolean teleportChangesScale = true;
    protected boolean teleportChangesGravity;
    protected boolean interactable;
    PortalExtension extension;
    @Nullable
    public String portalTag;
    public boolean isGlobalPortal;
    protected boolean fuseView;
    @Deprecated
    public boolean renderingMergable;
    protected boolean crossPortalCollisionEnabled;
    protected boolean doRenderPlayer;
    protected boolean visible;
    @Nullable
    protected List<String> commandsOnTeleported;
    @Environment(value=EnvType.CLIENT)
    PortalRenderInfo portalRenderInfo;
    public final PortalAnimation animation;
    @Nullable
    protected PortalState lastTickPortalState;
    protected boolean reloadAndSyncNextTick;
    @Nullable
    private class_238 thinBoundingBoxCache;
    @Nullable
    private class_238 boundingBoxCache;
    @Nullable
    private class_243 normalCache;
    @Nullable
    private class_243 contentDirectionCache;
    @Nullable
    private PortalState portalStateCache;
    @Nullable
    private class_265 thisSideCollisionExclusion;
    @Nullable
    private UnilateralPortalState thisSideStateCache;
    @Nullable
    private UnilateralPortalState otherSideStateCache;
    public static final Event<Consumer<Portal>> CLIENT_PORTAL_TICK_SIGNAL = Helper.createConsumerEvent();
    public static final Event<Consumer<Portal>> SERVER_PORTAL_TICK_SIGNAL = Helper.createConsumerEvent();
    public static final Event<Consumer<Portal>> PORTAL_DISPOSE_SIGNAL = Helper.createConsumerEvent();
    public static final Event<BiConsumer<Portal, class_2487>> READ_PORTAL_DATA_SIGNAL = Helper.createBiConsumerEvent();
    public static final Event<BiConsumer<Portal, class_2487>> WRITE_PORTAL_DATA_SIGNAL = Helper.createBiConsumerEvent();

    public static <T extends Portal> class_1299<T> createPortalEntityType(class_1299.class_4049<T> constructor) {
        return FabricEntityTypeBuilder.create((class_1311)class_1311.field_17715, constructor).dimensions(class_4048.method_18385((float)0.0f, (float)0.0f)).fireImmune().trackRangeBlocks(96).trackedUpdateRate(20).forceTrackedVelocityUpdates(true).build();
    }

    public Portal(class_1299<?> entityType, class_1937 world) {
        super(entityType, world);
        this.teleportChangesGravity = IPConfig.getConfig().portalsChangeGravityByDefault;
        this.interactable = true;
        this.isGlobalPortal = false;
        this.fuseView = false;
        this.renderingMergable = false;
        this.crossPortalCollisionEnabled = true;
        this.doRenderPlayer = true;
        this.visible = true;
        this.animation = new PortalAnimation();
        this.reloadAndSyncNextTick = false;
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    protected void method_5749(class_2487 compoundTag) {
        this.width = compoundTag.method_10574("width");
        this.height = compoundTag.method_10574("height");
        this.thickness = compoundTag.method_10574("thickness");
        this.axisW = Helper.getVec3d(compoundTag, "axisW").method_1029();
        this.axisH = Helper.getVec3d(compoundTag, "axisH").method_1029();
        this.dimensionTo = Helper.getWorldId(compoundTag, "dimensionTo");
        this.destination = Helper.getVec3d(compoundTag, "destination");
        this.specificPlayerId = Helper.getUuid(compoundTag, "specificPlayer");
        if (compoundTag.method_10545("portalShape")) {
            class_2487 portalShapeTag = compoundTag.method_10562("portalShape");
            PortalShape portalShape = PortalShapeSerialization.deserialize(portalShapeTag);
            if (portalShape == null) {
                LOGGER.error("Cannot deserialize portal shape {}", (Object)portalShapeTag);
                this.portalShape = RectangularPortalShape.INSTANCE;
            } else {
                this.portalShape = portalShape;
            }
        } else {
            boolean shapeNormalized;
            Mesh2D mesh2D = compoundTag.method_10545("specialShape") ? ((shapeNormalized = compoundTag.method_10577("shapeNormalized")) ? GeometryPortalShape.readOldMeshFromTag(compoundTag.method_10554("specialShape", 6)) : GeometryPortalShape.readOldMeshFromTagNonNormalized(compoundTag.method_10554("specialShape", 6), this.width / 2.0, this.height / 2.0)) : null;
            this.portalShape = mesh2D == null ? RectangularPortalShape.INSTANCE : new SpecialFlatPortalShape(mesh2D);
        }
        if (compoundTag.method_10545("teleportable")) {
            this.teleportable = compoundTag.method_10577("teleportable");
        }
        if (compoundTag.method_10545("rotationA")) {
            this.setRotationTransformationD(new DQuaternion(compoundTag.method_10583("rotationB"), compoundTag.method_10583("rotationC"), compoundTag.method_10583("rotationD"), compoundTag.method_10583("rotationA")));
        } else {
            this.rotation = null;
        }
        if (compoundTag.method_10545("interactable")) {
            this.interactable = compoundTag.method_10577("interactable");
        }
        if (compoundTag.method_10545("scale")) {
            this.scaling = compoundTag.method_10574("scale");
        }
        if (compoundTag.method_10545("teleportChangesScale")) {
            this.teleportChangesScale = compoundTag.method_10577("teleportChangesScale");
        }
        this.teleportChangesGravity = compoundTag.method_10545("teleportChangesGravity") ? compoundTag.method_10577("teleportChangesGravity") : IPConfig.getConfig().portalsChangeGravityByDefault;
        if (compoundTag.method_10545("portalTag")) {
            this.portalTag = compoundTag.method_10558("portalTag");
        }
        if (compoundTag.method_10545("fuseView")) {
            this.fuseView = compoundTag.method_10577("fuseView");
        }
        if (compoundTag.method_10545("renderingMergable")) {
            this.renderingMergable = compoundTag.method_10577("renderingMergable");
        }
        if (compoundTag.method_10545("hasCrossPortalCollision")) {
            this.crossPortalCollisionEnabled = compoundTag.method_10577("hasCrossPortalCollision");
        }
        if (compoundTag.method_10545("commandsOnTeleported")) {
            class_2499 list = compoundTag.method_10554("commandsOnTeleported", 8);
            this.commandsOnTeleported = list.stream().map(t -> ((class_2519)t).method_10714()).collect(Collectors.toList());
        } else {
            this.commandsOnTeleported = null;
        }
        this.doRenderPlayer = compoundTag.method_10545("doRenderPlayer") ? compoundTag.method_10577("doRenderPlayer") : true;
        this.visible = compoundTag.method_10545("isVisible") ? compoundTag.method_10577("isVisible") : true;
        this.animation.readFromTag(compoundTag);
        ((BiConsumer)READ_PORTAL_DATA_SIGNAL.invoker()).accept(this, compoundTag);
        this.updateCache();
    }

    protected void method_5652(class_2487 compoundTag) {
        compoundTag.method_10549("width", this.width);
        compoundTag.method_10549("height", this.height);
        compoundTag.method_10549("thickness", this.thickness);
        Helper.putVec3d(compoundTag, "axisW", this.axisW);
        Helper.putVec3d(compoundTag, "axisH", this.axisH);
        Helper.putWorldId(compoundTag, "dimensionTo", this.dimensionTo);
        Helper.putVec3d(compoundTag, "destination", this.getDestPos());
        if (this.specificPlayerId != null) {
            Helper.putUuid(compoundTag, "specificPlayer", this.specificPlayerId);
        }
        class_2487 portalShapeTag = PortalShapeSerialization.serialize(this.getPortalShape());
        compoundTag.method_10566("portalShape", (class_2520)portalShapeTag);
        compoundTag.method_10556("teleportable", this.teleportable);
        if (this.rotation != null) {
            compoundTag.method_10549("rotationA", this.rotation.w);
            compoundTag.method_10549("rotationB", this.rotation.x);
            compoundTag.method_10549("rotationC", this.rotation.y);
            compoundTag.method_10549("rotationD", this.rotation.z);
        }
        compoundTag.method_10556("interactable", this.interactable);
        compoundTag.method_10549("scale", this.scaling);
        compoundTag.method_10556("teleportChangesScale", this.teleportChangesScale);
        compoundTag.method_10556("teleportChangesGravity", this.teleportChangesGravity);
        if (this.portalTag != null) {
            compoundTag.method_10582("portalTag", this.portalTag);
        }
        compoundTag.method_10556("fuseView", this.fuseView);
        compoundTag.method_10556("renderingMergable", this.renderingMergable);
        compoundTag.method_10556("hasCrossPortalCollision", this.crossPortalCollisionEnabled);
        compoundTag.method_10556("doRenderPlayer", this.doRenderPlayer);
        compoundTag.method_10556("isVisible", this.visible);
        if (this.commandsOnTeleported != null) {
            class_2499 list = new class_2499();
            for (String command : this.commandsOnTeleported) {
                list.add((Object)class_2519.method_23256((String)command));
            }
            compoundTag.method_10566("commandsOnTeleported", (class_2520)list);
        }
        this.animation.writeToTag(compoundTag);
        ((BiConsumer)WRITE_PORTAL_DATA_SIGNAL.invoker()).accept(this, compoundTag);
    }

    @NotNull
    public PortalShape getPortalShape() {
        if (this.portalShape == null) {
            this.portalShape = RectangularPortalShape.INSTANCE;
        }
        return this.portalShape;
    }

    public void setPortalShape(PortalShape portalShape) {
        this.portalShape = portalShape;
        if (portalShape.isPlanar()) {
            this.thickness = 0.0;
        }
        this.updateCache();
    }

    public void setPortalShapeToDefault() {
        this.setPortalShape(RectangularPortalShape.INSTANCE);
    }

    @Override
    public void ip_onEntityPositionUpdated() {
        this.updateCache();
    }

    @Override
    public void ip_onRemoved(class_1297.class_5529 reason) {
        ((Consumer)PORTAL_DISPOSE_SIGNAL.invoker()).accept(this);
    }

    @Override
    public class_243 transformPoint(class_243 pos) {
        class_243 localPos = pos.method_1020(this.getOriginPos());
        return this.transformLocalVec(localPos).method_1019(this.getDestPos());
    }

    @Override
    public class_243 transformLocalVec(class_243 localVec) {
        return this.transformLocalVecNonScale(localVec).method_1021(this.scaling);
    }

    public class_243 getNormal() {
        if (this.normalCache == null) {
            this.normalCache = this.axisW.method_1036(this.axisH).method_1029();
        }
        return this.normalCache;
    }

    public class_243 getContentDirection() {
        if (this.contentDirectionCache == null) {
            this.contentDirectionCache = this.transformLocalVecNonScale(this.getNormal().method_1021(-1.0));
        }
        return this.contentDirectionCache;
    }

    public void onEntityTeleportedOnServer(class_1297 entity) {
        if (this.commandsOnTeleported != null) {
            McHelper.invokeCommandAs(entity, this.commandsOnTeleported);
        }
    }

    public void reloadAndSyncToClient() {
        this.reloadAndSyncNextTick = false;
        Validate.isTrue((!this.isGlobalPortal ? 1 : 0) != 0, (String)"global portal is not synced by this", (Object[])new Object[0]);
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0, (String)"must be used on server side", (Object[])new Object[0]);
        this.updateCache();
        class_2596<class_2602> packet = this.createSyncPacket();
        McHelper.sendToTrackers(this, packet);
    }

    public void reloadAndSyncToClientNextTick() {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0, (String)"must be used on server side", (Object[])new Object[0]);
        this.reloadAndSyncNextTick = true;
    }

    public void reloadAndSyncClusterToClientNextTick() {
        PortalExtension.forClusterPortals(this, Portal::reloadAndSyncToClientNextTick);
    }

    public void reloadAndSyncToClientWithTickDelay(int tickDelay) {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0, (String)"must be used on server side", (Object[])new Object[0]);
        ServerTaskList.of(this.method_5682()).addTask(MyTaskList.withDelay(tickDelay, () -> {
            this.reloadAndSyncToClientNextTick();
            return true;
        }));
    }

    public void updateCache() {
        if (this.axisW == null || this.axisH == null) {
            return;
        }
        this.portalStateCache = null;
        this.boundingBoxCache = null;
        this.thinBoundingBoxCache = null;
        this.normalCache = null;
        this.contentDirectionCache = null;
        this.thisSideCollisionExclusion = null;
        this.thisSideStateCache = null;
        this.otherSideStateCache = null;
    }

    @NotNull
    public class_238 method_5829() {
        if (this.boundingBoxCache == null) {
            this.boundingBoxCache = this.method_33332();
        }
        return this.boundingBoxCache;
    }

    @Override
    public class_243 getOriginPos() {
        return this.method_19538();
    }

    @Override
    public class_243 getDestPos() {
        return this.destination;
    }

    public void setOriginPos(class_243 pos) {
        this.method_33574(pos);
    }

    public void setDestinationDimension(class_5321<class_1937> dim) {
        this.dimensionTo = dim;
    }

    public void setDestination(class_243 destination) {
        this.destination = destination;
        this.updateCache();
    }

    @Override
    public boolean isFuseView() {
        return this.fuseView;
    }

    @Deprecated
    public boolean isRenderingMergable() {
        return this.renderingMergable;
    }

    public boolean isInteractable() {
        return this.interactable;
    }

    public void setInteractable(boolean interactable) {
        this.interactable = interactable;
    }

    @Override
    public class_1937 getOriginWorld() {
        return this.method_37908();
    }

    @Override
    public class_1937 getDestWorld() {
        return this.getDestinationWorld();
    }

    @Override
    public class_5321<class_1937> getDestDim() {
        return this.dimensionTo;
    }

    @Override
    public double getScale() {
        return this.scaling;
    }

    @Override
    public boolean getIsGlobal() {
        return this.isGlobalPortal;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setIsVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean canTeleportEntity(class_1297 entity) {
        if (!this.teleportable) {
            return false;
        }
        if (entity instanceof Portal) {
            return false;
        }
        if (entity instanceof class_1657 ? this.specificPlayerId != null && !entity.method_5667().equals(this.specificPlayerId) : this.specificPlayerId != null && !this.specificPlayerId.equals(class_156.field_25140)) {
            return false;
        }
        if (!O_O.allowTeleportingEntity(entity, this)) {
            return false;
        }
        return ((ImmPtlEntityExtension)entity).imm_ptl_canTeleportThroughPortal(this);
    }

    public boolean canCollideWithEntity(class_1297 entity) {
        return this.canTeleportEntity(entity);
    }

    public boolean isInteractableBy(class_1657 player) {
        if (!IPConfig.getConfig().enableCrossPortalInteraction) {
            return false;
        }
        if (!this.isInteractable()) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        return this.canTeleportEntity((class_1297)player);
    }

    @Override
    @Nullable
    public DQuaternion getRotation() {
        return this.rotation;
    }

    @NotNull
    public DQuaternion getRotationD() {
        return DQuaternion.fromNullable(this.getRotation());
    }

    @Override
    public boolean getDoRenderPlayer() {
        return this.doRenderPlayer;
    }

    public boolean getTeleportable() {
        return this.teleportable;
    }

    public void setTeleportable(boolean teleportable) {
        this.teleportable = teleportable;
    }

    public void setOrientationAndSize(class_243 newAxisW, class_243 newAxisH, double newWidth, double newHeight) {
        this.setOrientation(newAxisW, newAxisH);
        this.width = newWidth;
        this.height = newHeight;
        this.updateCache();
    }

    public void setOrientation(class_243 newAxisW, class_243 newAxisH) {
        this.axisW = newAxisW.method_1029();
        this.axisH = newAxisH.method_1029();
        this.updateCache();
    }

    public void setWidth(double newWidth) {
        this.width = newWidth;
        this.updateCache();
    }

    public void setHeight(double newHeight) {
        this.height = newHeight;
        this.updateCache();
    }

    public void setThickness(double newThickness) {
        this.thickness = newThickness;
        this.updateCache();
    }

    public void setPortalSize(double newWidth, double newHeight, double newThickness) {
        this.width = newWidth;
        this.height = newHeight;
        this.thickness = newThickness;
        this.updateCache();
    }

    public DQuaternion getOrientationRotation() {
        return PortalManipulation.getPortalOrientationQuaternion(this.axisW, this.axisH);
    }

    public void setOrientationRotation(DQuaternion quaternion) {
        DQuaternion fixed = this.method_37908().method_8608() ? quaternion : quaternion.fixFloatingPointErrorAccumulation();
        this.setOrientation(McHelper.getAxisWFromOrientation(fixed), McHelper.getAxisHFromOrientation(fixed));
    }

    public void setRotation(@Nullable DQuaternion quaternion) {
        this.setRotationTransformationD(quaternion);
    }

    public void setRotationTransformation(@Nullable DQuaternion quaternion) {
        this.setRotationTransformationD(quaternion);
    }

    public void setRotationTransformationD(@Nullable DQuaternion quaternion) {
        this.rotation = quaternion == null ? null : quaternion.fixFloatingPointErrorAccumulation();
        this.updateCache();
    }

    public void setOtherSideOrientation(DQuaternion otherSideOrientation) {
        this.setRotation(PortalManipulation.computeDeltaTransformation(this.getOrientationRotation(), otherSideOrientation));
    }

    public void setScaleTransformation(double newScale) {
        this.scaling = newScale;
    }

    @Environment(value=EnvType.CLIENT)
    public void renderViewAreaMesh(class_243 portalPosRelativeToCamera, TriangleConsumer vertexOutput) {
        if (this instanceof Mirror) {
            boolean offsetFront = IrisInterface.invoker.isShaders() || IPGlobal.pureMirror;
            double mirrorOffset = offsetFront ? 0.01 : -0.01;
            portalPosRelativeToCamera = portalPosRelativeToCamera.method_1019(((Mirror)this).getNormal().method_1021(mirrorOffset));
        }
        this.getPortalShape().renderViewAreaMesh(portalPosRelativeToCamera, this.getThisSideState(), vertexOutput, this.getIsGlobal());
    }

    @NotNull
    public class_2596<class_2602> method_18002(class_3231 serverEntity) {
        return this.createSyncPacket();
    }

    private class_2596<class_2602> createSyncPacket() {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0);
        class_2487 compoundTag = new class_2487();
        this.method_5652(compoundTag);
        return ServerPlayNetworking.createS2CPacket((class_8710)new ImmPtlNetworking.PortalSyncPacket(this.method_5628(), this.method_5667(), this.method_5864(), PortalAPI.serverDimKeyToInt(this.method_5682(), (class_5321<class_1937>)this.getOriginDim()), this.method_23317(), this.method_23318(), this.method_23321(), compoundTag));
    }

    public boolean method_5680(class_3222 spectator) {
        if (this.specificPlayerId == null) {
            return true;
        }
        return spectator.method_5667().equals(this.specificPlayerId);
    }

    public void method_5773() {
        if (this.method_5829().equals((Object)NULL_BOX)) {
            LOGGER.error("Abnormal bounding box {}", (Object)this);
        }
        this.lastTickPortalState = this.getThisTickPortalState();
        if (!this.method_37908().method_8608() && this.reloadAndSyncNextTick) {
            this.reloadAndSyncToClient();
        }
        if (this.method_37908().method_8608()) {
            ((Consumer)CLIENT_PORTAL_TICK_SIGNAL.invoker()).accept(this);
        } else {
            if (!this.isPortalValid()) {
                LOGGER.info("Removed invalid portal {}", (Object)this);
                this.method_5650(class_1297.class_5529.field_26998);
                return;
            }
            ((Consumer)SERVER_PORTAL_TICK_SIGNAL.invoker()).accept(this);
        }
        this.animation.tick(this);
        super.method_5773();
    }

    @NotNull
    protected class_238 method_33332() {
        if (this.axisW == null) {
            this.boundingBoxCache = null;
            return NULL_BOX;
        }
        if (this.boundingBoxCache == null) {
            this.boundingBoxCache = this.getPortalShape().getBoundingBox(this.getThisSideState(), this.shouldLimitBoundingBox(), 0.2);
        }
        return this.boundingBoxCache;
    }

    protected boolean shouldLimitBoundingBox() {
        return !this.getIsGlobal();
    }

    public void method_5784(class_1313 type, class_243 movement) {
    }

    public boolean isPortalValid() {
        boolean valid;
        boolean bl = valid = this.dimensionTo != null && this.width != 0.0 && this.height != 0.0 && this.axisW != null && this.axisH != null && this.getDestPos() != null && this.axisW.method_1027() > 0.9 && this.axisH.method_1027() > 0.9 && this.method_23318() > (double)(McHelper.getMinY((class_1936)this.method_37908()) - 100);
        if (valid) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_3218 destWorld = serverLevel.method_8503().method_3847(this.dimensionTo);
                if (destWorld == null) {
                    LOGGER.error("Portal Dest Dimension Missing {}", (Object)this.dimensionTo.method_29177());
                    return false;
                }
                boolean inWorldBorder = destWorld.method_8621().method_11952(class_2338.method_49638((class_2374)this.getDestPos()));
                if (!inWorldBorder) {
                    LOGGER.error("Destination out of World Border {}", (Object)this);
                    return false;
                }
            }
            if (this.method_37908().method_8608()) {
                return this.isPortalValidClient();
            }
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private boolean isPortalValidClient() {
        boolean contains = ClientWorldLoader.getServerDimensions().contains(this.dimensionTo);
        if (!contains) {
            LOGGER.error("Client Portal Dest Dimension Missing {}", (Object)this.dimensionTo.method_29177());
        }
        return contains;
    }

    @Override
    @Nullable
    public UUID getDiscriminator() {
        return this.method_5667();
    }

    @NotNull
    public String toString() {
        return String.format("%s{%s,%s,(%s %.1f %.1f %.1f)->(%s %.1f %.1f %.1f)%s%s%s}", this.getClass().getSimpleName(), this.method_5628(), this.getApproximateFacingDirection(), this.method_37908().method_27983().method_29177(), this.method_23317(), this.method_23318(), this.method_23321(), this.dimensionTo.method_29177(), this.getDestPos().field_1352, this.getDestPos().field_1351, this.getDestPos().field_1350, this.specificPlayerId != null ? ",specificAccessor:" + this.specificPlayerId.toString() : "", this.hasScaling() ? ",scale:" + this.scaling : "", this.portalTag != null ? "," + this.portalTag : "");
    }

    public class_2350 getApproximateFacingDirection() {
        return class_2350.method_10142((double)this.getNormal().field_1352, (double)this.getNormal().field_1351, (double)this.getNormal().field_1350);
    }

    public class_243 transformVelocityRelativeToPortal(class_243 originalVelocityRelativeToPortal, class_1297 entity, class_243 oldEntityPos) {
        class_243 result = this.transformLocalVec(originalVelocityRelativeToPortal);
        int maxVelocity = 15;
        if (originalVelocityRelativeToPortal.method_1033() > 15.0) {
            result = result.method_1029().method_1021(15.0);
        }
        if (entity instanceof class_1688 && result.method_1027() < 0.5) {
            result = result.method_1021(2.0);
        }
        return result;
    }

    public double getDistanceToPlane(class_243 pos) {
        return pos.method_1020(this.getOriginPos()).method_1026(this.getNormal());
    }

    public boolean isInFrontOfPortal(class_243 pos) {
        return this.getDistanceToPlane(pos) > 0.0;
    }

    public class_243 getPointInPlane(double xInPlane, double yInPlane) {
        return this.getOriginPos().method_1019(this.getPointInPlaneLocal(xInPlane, yInPlane));
    }

    public class_243 getPointInPlaneLocal(double xInPlane, double yInPlane) {
        return this.axisW.method_1021(xInPlane).method_1019(this.axisH.method_1021(yInPlane));
    }

    public class_243 getPointInPlaneLocalClamped(double xInPlane, double yInPlane) {
        return this.getPointInPlaneLocal(class_3532.method_15350((double)xInPlane, (double)(-this.width / 2.0), (double)(this.width / 2.0)), class_3532.method_15350((double)yInPlane, (double)(-this.height / 2.0), (double)(this.height / 2.0)));
    }

    public class_243[] getFourVerticesLocal(double shrinkFactor) {
        class_243[] vertices = new class_243[]{this.getPointInPlaneLocal(this.width / 2.0 - shrinkFactor, -this.height / 2.0 + shrinkFactor), this.getPointInPlaneLocal(-this.width / 2.0 + shrinkFactor, -this.height / 2.0 + shrinkFactor), this.getPointInPlaneLocal(this.width / 2.0 - shrinkFactor, this.height / 2.0 - shrinkFactor), this.getPointInPlaneLocal(-this.width / 2.0 + shrinkFactor, this.height / 2.0 - shrinkFactor)};
        return vertices;
    }

    private class_243[] getFourVerticesLocalRotated(double shrinkFactor) {
        class_243[] fourVerticesLocal = this.getFourVerticesLocal(shrinkFactor);
        fourVerticesLocal[0] = this.transformLocalVec(fourVerticesLocal[0]);
        fourVerticesLocal[1] = this.transformLocalVec(fourVerticesLocal[1]);
        fourVerticesLocal[2] = this.transformLocalVec(fourVerticesLocal[2]);
        fourVerticesLocal[3] = this.transformLocalVec(fourVerticesLocal[3]);
        return fourVerticesLocal;
    }

    private class_243[] getFourVerticesLocalCullable(double shrink) {
        double xStart = -this.width / 2.0;
        double xEnd = this.width / 2.0;
        double yStart = -this.height / 2.0;
        double yEnd = this.height / 2.0;
        class_243[] vertices = new class_243[]{this.getPointInPlaneLocal(xEnd - shrink, yStart + shrink), this.getPointInPlaneLocal(xStart + shrink, yStart + shrink), this.getPointInPlaneLocal(xEnd - shrink, yEnd - shrink), this.getPointInPlaneLocal(xStart + shrink, yEnd - shrink)};
        return vertices;
    }

    public final class_243 transformPointRough(class_243 pos) {
        class_243 offset = this.getDestPos().method_1020(this.getOriginPos());
        return pos.method_1019(offset);
    }

    @Override
    public class_243 transformLocalVecNonScale(class_243 localVec) {
        if (this.rotation == null) {
            return localVec;
        }
        return this.rotation.rotate(localVec);
    }

    public class_243 inverseTransformLocalVecNonScale(class_243 localVec) {
        if (this.rotation == null) {
            return localVec;
        }
        return this.rotation.getConjugated().rotate(localVec);
    }

    @Override
    public class_243 inverseTransformLocalVec(class_243 localVec) {
        return this.inverseTransformLocalVecNonScale(localVec).method_1021(1.0 / this.scaling);
    }

    @Override
    public class_243 inverseTransformPoint(class_243 point) {
        return this.getOriginPos().method_1019(this.inverseTransformLocalVec(point.method_1020(this.getDestPos())));
    }

    public boolean isMovedThroughPortal(class_243 lastTickPos, class_243 pos) {
        return this.rayTrace(lastTickPos, pos) != null;
    }

    @Nullable
    public class_243 rayTrace(class_243 from, class_243 to) {
        return this.lenientRayTrace(from, to, 0.001);
    }

    @Nullable
    public class_243 lenientRayTrace(class_243 from, class_243 to, double leniency) {
        RayTraceResult rayTraceResult = this.getPortalShape().raytracePortalShape(this.getThisSideState(), from, to, leniency);
        if (rayTraceResult == null) {
            return null;
        }
        return rayTraceResult.hitPos();
    }

    @Nullable
    public RayTraceResult generalRayTrace(class_243 from, class_243 to, double leniency) {
        return this.getPortalShape().raytracePortalShape(this.getThisSideState(), from, to, leniency);
    }

    @Override
    public double getDistanceToNearestPointInPortal(class_243 point) {
        return this.getPortalShape().roughDistanceToPortalShape(this.getThisSideState(), point);
    }

    public class_243 getPointProjectedToPlane(class_243 pos) {
        class_243 originPos = this.getOriginPos();
        return this.getLocalVecProjectedToPlane(pos.method_1020(originPos)).method_1019(originPos);
    }

    public class_243 getLocalVecProjectedToPlane(class_243 offset) {
        double yInPlane = offset.method_1026(this.axisH);
        double xInPlane = offset.method_1026(this.axisW);
        return this.axisW.method_1021(xInPlane).method_1019(this.axisH.method_1021(yInPlane));
    }

    public class_243 getNearestPointInPortal(class_243 pos) {
        class_243 originPos = this.getOriginPos();
        class_243 offset = pos.method_1020(originPos);
        double yInPlane = offset.method_1026(this.axisH);
        double xInPlane = offset.method_1026(this.axisW);
        xInPlane = class_3532.method_15350((double)xInPlane, (double)(-this.width / 2.0), (double)(this.width / 2.0));
        yInPlane = class_3532.method_15350((double)yInPlane, (double)(-this.height / 2.0), (double)(this.height / 2.0));
        return originPos.method_1019(this.axisW.method_1021(xInPlane)).method_1019(this.axisH.method_1021(yInPlane));
    }

    public class_1937 getDestinationWorld() {
        return this.getDestinationWorld(this.method_37908().method_8608());
    }

    private class_1937 getDestinationWorld(boolean isClient) {
        if (isClient) {
            return CHelper.getClientWorld(this.dimensionTo);
        }
        MinecraftServer server = this.method_5682();
        assert (server != null);
        return server.method_3847(this.dimensionTo);
    }

    public static boolean isParallelPortal(Portal a, Portal b) {
        if (a == b) {
            return false;
        }
        return a.dimensionTo == b.method_37908().method_27983() && a.method_37908().method_27983() == b.dimensionTo && a.getOriginPos().method_1022(b.getDestPos()) < 0.1 && a.getDestPos().method_1022(b.getOriginPos()) < 0.1 && a.getNormal().method_1026(b.getContentDirection()) < -0.9;
    }

    public static boolean isParallelOrientedPortal(Portal currPortal, Portal outerPortal) {
        double dot = currPortal.getOriginPos().method_1020(outerPortal.getDestPos()).method_1026(outerPortal.getContentDirection());
        return currPortal.method_37908().method_27983() == outerPortal.dimensionTo && currPortal.getNormal().method_1026(outerPortal.getContentDirection()) < -0.9 && Math.abs(dot) < 0.001;
    }

    public static boolean isReversePortal(Portal a, Portal b) {
        return a.dimensionTo == b.method_37908().method_27983() && a.method_37908().method_27983() == b.dimensionTo && a.getOriginPos().method_1022(b.getDestPos()) < 0.1 && a.getDestPos().method_1022(b.getOriginPos()) < 0.1 && a.getNormal().method_1026(b.getContentDirection()) > 0.9;
    }

    public static boolean isFlippedPortal(Portal a, Portal b) {
        if (a == b) {
            return false;
        }
        return a.method_37908() == b.method_37908() && a.dimensionTo == b.dimensionTo && a.getOriginPos().method_1022(b.getOriginPos()) < 0.1 && a.getDestPos().method_1022(b.getDestPos()) < 0.1 && a.getNormal().method_1026(b.getNormal()) < -0.9;
    }

    @Override
    public double getDestAreaRadiusEstimation() {
        return Math.max(this.width, this.height) * this.scaling;
    }

    @Override
    public boolean isConventionalPortal() {
        return true;
    }

    @Override
    public class_238 getThinBoundingBox() {
        if (this.thinBoundingBoxCache == null) {
            this.thinBoundingBoxCache = this.getPortalShape().getBoundingBox(this.getThisSideState(), false, 0.001);
        }
        return this.thinBoundingBoxCache;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean isRoughlyVisibleTo(class_243 cameraPos) {
        return this.getPortalShape().roughTestVisibility(this.getThisSideState(), cameraPos, IrisInterface.invoker.isShaders());
    }

    @Override
    @Nullable
    public Plane getInnerClipping() {
        return this.getPortalShape().getInnerClipping(this.getThisSideState(), this.getOtherSideState(), this);
    }

    @Override
    @Nullable
    public class_243[] getOuterFrustumCullingVertices() {
        return this.getFourVerticesLocalCullable(0.0);
    }

    public Matrix4d getFullSpaceTransformation() {
        class_243 originPos = this.getOriginPos();
        class_243 destPos = this.getDestPos();
        DQuaternion rot = this.getRotationD();
        return new Matrix4d().translation(destPos.field_1352, destPos.field_1351, destPos.field_1350).scale(this.getScale()).rotate((Quaternionfc)rot.toMcQuaternion()).translate(-originPos.field_1352, -originPos.field_1351, -originPos.field_1350);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getThickness() {
        return this.thickness;
    }

    public class_243 getAxisW() {
        return this.axisW;
    }

    public void setAxisW(class_243 axisW) {
        this.axisW = axisW;
        this.updateCache();
    }

    public class_243 getAxisH() {
        return this.axisH;
    }

    public void setAxisH(class_243 axisH) {
        this.axisH = axisH;
        this.updateCache();
    }

    public void setDestDim(class_5321<class_1937> dimensionTo) {
        this.dimensionTo = dimensionTo;
    }

    public class_243 getDestination() {
        return this.destination;
    }

    public double getScaling() {
        return this.scaling;
    }

    public void setScaling(double scaling) {
        this.scaling = scaling;
        this.updateCache();
    }

    public boolean isTeleportChangesScale() {
        return this.teleportChangesScale;
    }

    public void setFuseView(boolean fuseView) {
        this.fuseView = fuseView;
    }

    public boolean isCrossPortalCollisionEnabled() {
        return this.crossPortalCollisionEnabled;
    }

    public void setCrossPortalCollisionEnabled(boolean crossPortalCollisionEnabled) {
        this.crossPortalCollisionEnabled = crossPortalCollisionEnabled;
    }

    public boolean isDoRenderPlayer() {
        return this.doRenderPlayer;
    }

    public void setDoRenderPlayer(boolean doRenderPlayer) {
        this.doRenderPlayer = doRenderPlayer;
    }

    @Nullable
    public List<String> getCommandsOnTeleported() {
        return this.commandsOnTeleported;
    }

    public void setCommandsOnTeleported(@Nullable List<String> commandsOnTeleported) {
        this.commandsOnTeleported = commandsOnTeleported;
    }

    public TransformationDesc getTransformationDesc() {
        return new TransformationDesc(this.getDestDim(), this.getFullSpaceTransformation(), this.getRotationD(), this.getScale());
    }

    @Override
    public boolean cannotRenderInMe(Portal portal) {
        if (this.respectParallelOrientedPortal()) {
            return Portal.isParallelPortal(portal, this);
        }
        return Portal.isParallelOrientedPortal(portal, this);
    }

    public void myUnsetRemoved() {
        this.method_31482();
    }

    public void method_18382() {
        this.boundingBoxCache = null;
    }

    @Override
    @Nullable
    public Matrix4f getAdditionalCameraTransformation() {
        return PortalRenderer.getPortalTransformation(this);
    }

    public boolean canDoOuterFrustumCulling() {
        if (this.isFuseView()) {
            return false;
        }
        if (!this.isVisible()) {
            return false;
        }
        return this.getPortalShape().canDoOuterFrustumCulling();
    }

    public boolean isTeleportable() {
        return this.teleportable;
    }

    public boolean respectParallelOrientedPortal() {
        return false;
    }

    public void onCollidingWithEntity(class_1297 entity) {
    }

    @Override
    public boolean getHasCrossPortalCollision() {
        return this.crossPortalCollisionEnabled;
    }

    public boolean getTeleportChangesScale() {
        return this.teleportChangesScale;
    }

    public void setTeleportChangesScale(boolean teleportChangesScale) {
        this.teleportChangesScale = teleportChangesScale;
    }

    public boolean getTeleportChangesGravity() {
        return this.teleportChangesGravity;
    }

    public boolean isTeleportChangesGravity() {
        return this.teleportChangesGravity;
    }

    public void setTeleportChangesGravity(boolean cond) {
        this.teleportChangesGravity = cond;
    }

    public class_2350 getTeleportedGravityDirection(class_2350 oldGravityDir) {
        if (!this.getTeleportChangesGravity()) {
            return oldGravityDir;
        }
        return this.getTransformedGravityDirection(oldGravityDir);
    }

    public class_2350 getTransformedGravityDirection(class_2350 oldGravityDir) {
        class_243 oldGravityVec = class_243.method_24954((class_2382)oldGravityDir.method_10163());
        class_243 newGravityVec = this.transformLocalVecNonScale(oldGravityVec);
        return class_2350.method_10142((double)newGravityVec.field_1352, (double)newGravityVec.field_1351, (double)newGravityVec.field_1350);
    }

    @NotNull
    public PortalState getPortalState() {
        Validate.isTrue((this.axisH != null ? 1 : 0) != 0, (String)"the portal is not yet initialized", (Object[])new Object[0]);
        return new PortalState((class_5321<class_1937>)this.method_37908().method_27983(), this.getOriginPos(), this.dimensionTo, this.getDestPos(), this.getScale(), this.getRotationD(), this.getOrientationRotation(), this.width, this.height, this.thickness, this instanceof Mirror);
    }

    public void setPortalState(PortalState state) {
        Validate.isTrue((this.method_37908().method_27983() == state.fromWorld ? 1 : 0) != 0);
        Validate.isTrue((this.dimensionTo == state.toWorld ? 1 : 0) != 0);
        this.width = state.width;
        this.height = state.height;
        this.thickness = state.thickness;
        this.setOriginPos(state.fromPos);
        this.setDestination(state.toPos);
        PortalManipulation.setPortalOrientationQuaternion(this, state.orientation);
        if (DQuaternion.isClose(state.rotation, DQuaternion.identity)) {
            this.setRotationTransformationD(null);
        } else {
            this.setRotationTransformationD(state.rotation);
        }
        this.setScaleTransformation(state.scaling);
    }

    public UnilateralPortalState getThisSideState() {
        if (this.thisSideStateCache == null) {
            this.thisSideStateCache = new UnilateralPortalState((class_5321<class_1937>)this.getOriginDim(), this.getOriginPos(), this.getOrientationRotation(), this.width, this.height, this.thickness);
        }
        return this.thisSideStateCache;
    }

    public UnilateralPortalState getOtherSideState() {
        if (this.otherSideStateCache == null) {
            PortalState portalState = this.getPortalState();
            this.otherSideStateCache = UnilateralPortalState.extractOtherSide(portalState);
        }
        return this.otherSideStateCache;
    }

    public void setThisSideState(UnilateralPortalState ups) {
        this.setThisSideState(ups, false);
    }

    public void setThisSideState(UnilateralPortalState ups, boolean lockScale) {
        Validate.notNull((Object)ups);
        PortalState portalState = this.getPortalState();
        PortalState newPortalState = portalState.withThisSideUpdated(ups, lockScale);
        this.setPortalState(newPortalState);
    }

    @Environment(value=EnvType.CLIENT)
    public void acceptDataSync(class_243 pos, class_2487 customData) {
        PortalState oldState = this.getPortalState();
        this.method_33574(pos);
        this.method_5749(customData);
        if (this.animation.defaultAnimation.durationTicks > 0) {
            this.animation.defaultAnimation.startClientDefaultAnimation(this, oldState);
        }
        ((Consumer)CLIENT_PORTAL_ACCEPT_SYNC_EVENT.invoker()).accept(this);
    }

    public class_2487 writePortalDataToNbt() {
        class_2487 nbtCompound = new class_2487();
        this.method_5652(nbtCompound);
        return nbtCompound;
    }

    public void readPortalDataFromNbt(class_2487 compound) {
        block2: {
            try {
                this.method_5749(compound);
            }
            catch (Exception e) {
                LOGGER.error("Failed to read portal data from nbt {}", (Object)compound, (Object)e);
                if (this.isPortalValid()) break block2;
                this.method_31745(class_1297.class_5529.field_26998);
            }
        }
    }

    public void updatePortalFromNbt(class_2487 newNbt) {
        class_2487 data = this.writePortalDataToNbt();
        newNbt.method_10541().forEach(key -> data.method_10566(key, newNbt.method_10580(key)));
        this.readPortalDataFromNbt(data);
    }

    public void rectifyClusterPortals(boolean sync) {
        PortalExtension.get(this).rectifyClusterPortals(this, sync);
    }

    public void reloadPortal() {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0);
        this.updateCache();
        this.rectifyClusterPortals(true);
        this.reloadAndSyncToClientNextTick();
    }

    public DefaultPortalAnimation getDefaultAnimation() {
        return this.animation.defaultAnimation;
    }

    public void clearAnimationDrivers(boolean clearThisSide, boolean clearOtherSide) {
        this.animation.clearAnimationDrivers(this, clearThisSide, clearOtherSide);
    }

    public void addThisSideAnimationDriver(PortalAnimationDriver driver) {
        this.getAnimationView().addThisSideAnimation(driver);
        this.reloadAndSyncClusterToClientNextTick();
    }

    public void addOtherSideAnimationDriver(PortalAnimationDriver driver) {
        this.getAnimationView().addOtherSideAnimation(driver);
        this.reloadAndSyncClusterToClientNextTick();
    }

    public void pauseAnimation() {
        this.animation.setPaused(this, true);
    }

    public void resumeAnimation() {
        this.animation.setPaused(this, false);
    }

    public void resetAnimationReferenceState(boolean resetThisSide, boolean resetOtherSide) {
        this.animation.resetReferenceState(this, resetThisSide, resetOtherSide);
    }

    public AnimationView getAnimationView() {
        PortalExtension extension = PortalExtension.get(this);
        if (extension.flippedPortal != null && extension.flippedPortal.animation.hasAnimationDriver()) {
            return new AnimationView(this, extension.flippedPortal, IntraClusterRelation.FLIPPED);
        }
        if (extension.reversePortal != null && extension.reversePortal.animation.hasAnimationDriver()) {
            return new AnimationView(this, extension.reversePortal, IntraClusterRelation.REVERSE);
        }
        if (extension.parallelPortal != null && extension.parallelPortal.animation.hasAnimationDriver()) {
            return new AnimationView(this, extension.parallelPortal, IntraClusterRelation.PARALLEL);
        }
        return new AnimationView(this, this, IntraClusterRelation.SAME);
    }

    public boolean isOtherSideChunkLoaded() {
        Validate.isTrue((!this.method_37908().method_8608() ? 1 : 0) != 0);
        return McHelper.isServerChunkFullyLoaded((class_3218)this.getDestWorld(), new class_1923(class_2338.method_49638((class_2374)this.getDestPos())));
    }

    @Nullable
    public PortalState getLastTickPortalState() {
        if (this.lastTickPortalState == null) {
            return this.getThisTickPortalState();
        }
        return this.lastTickPortalState;
    }

    @Nullable
    public PortalState getThisTickPortalState() {
        if (this.portalStateCache == null) {
            this.portalStateCache = this.getPortalState();
        }
        return this.portalStateCache;
    }

    public PortalState getAnimationEndingState() {
        return this.animation.getAnimationEndingState(this);
    }

    public class_243 transformFromPortalLocalToWorld(class_243 localPos) {
        return this.axisW.method_1021(localPos.field_1352).method_1019(this.axisH.method_1021(localPos.field_1351)).method_1019(this.getNormal().method_1021(localPos.field_1350)).method_1019(this.getOriginPos());
    }

    public class_243 transformFromWorldToPortalLocal(class_243 worldPos) {
        class_243 relativePos = worldPos.method_1020(this.getOriginPos());
        return new class_243(relativePos.method_1026(this.axisW), relativePos.method_1026(this.axisH), relativePos.method_1026(this.getNormal()));
    }

    @Nullable
    public Portal getAnimationHolder() {
        if (this.animation.hasAnimationDriver()) {
            return this;
        }
        PortalExtension portalExtension = PortalExtension.get(this);
        if (portalExtension.flippedPortal != null && portalExtension.flippedPortal.animation.hasAnimationDriver()) {
            return portalExtension.flippedPortal;
        }
        if (portalExtension.reversePortal != null && portalExtension.reversePortal.animation.hasAnimationDriver()) {
            return portalExtension.reversePortal;
        }
        if (portalExtension.parallelPortal != null && portalExtension.parallelPortal.animation.hasAnimationDriver()) {
            return portalExtension.parallelPortal;
        }
        return null;
    }

    public Portal getPossibleAnimationHolder() {
        Portal holder = this.getAnimationHolder();
        if (holder != null) {
            return holder;
        }
        return this;
    }

    public long getAnimationEffectiveTime() {
        Portal holder = this.getPossibleAnimationHolder();
        return holder.animation.getEffectiveTime(holder.method_37908().method_8510());
    }

    public void disableDefaultAnimation() {
        this.animation.defaultAnimation.durationTicks = 0;
        this.reloadAndSyncToClientNextTick();
    }

    public class_265 getThisSideCollisionExclusion() {
        if (this.thisSideCollisionExclusion == null) {
            this.thisSideCollisionExclusion = this.getPortalShape().getThisSideCollisionExclusion(this.getThisSideState());
        }
        return this.thisSideCollisionExclusion;
    }

    public record TransformationDesc(class_5321<class_1937> dimensionTo, Matrix4d fullSpaceTransformation, DQuaternion rotation, double scaling) {
        public static boolean isRoughlyEqual(TransformationDesc a, TransformationDesc b) {
            if (a.dimensionTo != b.dimensionTo) {
                return false;
            }
            Matrix4d diff = new Matrix4d().set((Matrix4dc)a.fullSpaceTransformation).sub((Matrix4dc)b.fullSpaceTransformation);
            double diffSquareSum = diff.m00() * diff.m00() + diff.m01() * diff.m01() + diff.m02() * diff.m02() + diff.m03() * diff.m03() + diff.m10() * diff.m10() + diff.m11() * diff.m11() + diff.m12() * diff.m12() + diff.m13() * diff.m13() + diff.m20() * diff.m20() + diff.m21() * diff.m21() + diff.m22() * diff.m22() + diff.m23() * diff.m23() + diff.m30() * diff.m30() + diff.m31() * diff.m31() + diff.m32() * diff.m32() + diff.m33() * diff.m33();
            return diffSquareSum < 0.1;
        }
    }
}

